<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\Functional\Either;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;

interface BookingRepository
{
    public function searchConfirm(DateStart $dateStart, DateEnd $dateEnd, string $orderBy);
    public function searchConfirmExcel(DateStart $dateStart, DateEnd $dateEnd, string $orderBy);
    public function search(BookingCode $code);
    public function getReportExcel(ReportExcelRequirements $requirements);
    public function updateManuallyConfirmed(UpdateManuallyConfirmedBooking $model);
    /**
     * @return Either<Booking, BookingNotFound>
     */
    public function find(StorageCriteria $criteria): Either;
}
