<?php

namespace App\Modules\Booking\Application\UpdateManuallyConfirmed;

use App\Modules\Booking\Domain\BookingManuallyConfirmed;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Domain\UpdateManuallyConfirmedBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateManuallyConfirmedQueryHandler implements QueryHandler
{
    public function __construct(private BookingManuallyConfirmedUpdater $updater)
    {
    }

    public function __invoke(UpdateManuallyConfirmedQuery $query): UpdateManuallyConfirmedResponse
    {
        $model = new UpdateManuallyConfirmedBooking(
            new IdBooking($query->id()),
            new BookingManuallyConfirmed($query->manuallyConfirmed()),
        );
        return $this->updater->__invoke($model);
    }
}
