<?php

namespace App\Modules\Booking\Application\UpdateManuallyConfirmed;

use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Booking\Domain\UpdateManuallyConfirmedBooking;

final class BookingManuallyConfirmedUpdater
{
    public function __construct(private BookingRepository $repository)
    {
    }

    public function __invoke(UpdateManuallyConfirmedBooking $booking): UpdateManuallyConfirmedResponse
    {
        return new UpdateManuallyConfirmedResponse($this->repository->updateManuallyConfirmed($booking));
    }
}
