<?php

namespace App\Modules\Booking\Application\SearchConfirm;

use App\Modules\Booking\Domain\BookingStatus;
use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class SearchConfirmBookingQueryHandler implements QueryHandler
{
    public function __construct(private BookingConfirmSearcher $lister)
    {
    }

    public function __invoke(SearchConfirmBookingQuery $query): SearchConfirmBookingResponse
    {
        return $this->lister->__invoke(
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->orderBy()
        );
    }
}
