<?php

namespace App\Modules\Booking\Application\Find;

use App\Modules\Shared\Domain\ErrorDictionary;

class BookingNotFound
{
    private $message;
    private $code;

    public function __construct()
    {
        $this->message = 'Reserva no existe';
        $this->code = ErrorDictionary::ERRORS['INTERNAL']['BOOKING']['INTERNAL_BOOKING_EXISTS']['INTERNAL_BOOKING_NOT_EXISTS'];
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function getCode(): string
    {
        return $this->code;
    }
}
