<?php

namespace App\Modules\AdminRole\Infraestructure;

use App\Modules\AdminRole\Domain\AdminRoleRepository;
use App\Modules\AdminRole\Domain\IdAdminRole;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlAdminRoleRepository implements AdminRoleRepository {

    public function copy(IdAdminRole $id) {
        return Requester::requestInsert(
            'CALL sp_admin_role_copy(?,@sts,@cod,@msg,@id)',
            [
                $id->getValue()
            ]
        );
    }

    // public function insert(AdminRole $id) {
    //     return (new ActionHandler())->handle(DB::select(
    //         'call sp_admin_role_insert(?,?,?,?)',
    //         [
    //             $id->getName()->getValue(),
    //             $id->getAbrv()->getValue(),
    //             $id->getLock()->getValue(),
    //             $id->getStatus()->getValue(),
    //         ]
    //     ));
    // }

    // public function update(AdminRole $id) {
    //     return (new ActionHandler())->handle(DB::select(
    //         'call sp_admin_role_update(?,?,?,?)',
    //         [
    //             $id->getId()->getValue(),
    //             $id->getName()->getValue(),
    //             $id->getAbrv()->getValue(),
    //             $id->getStatus()->getValue(),
    //         ]
    //     ));
    // }

    public function index(IdAdminRole $id) {
        return DB::select(
            'call sp_admin_role_index(?)',
            [
                $id->getValue()
            ]
        );
    }

    public function list($action) {
        return DB::select(
            'call sp_admin_role_list(?)',
            [
                $action
            ]
        );
    }
    
}