<?php

namespace App\Modules\Admin\Domain;

use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\AdminRole\Domain\IdAdminRole;
use App\Modules\City\Domain\IdCity;
use App\Modules\Country\Domain\IdCountry;
use App\Modules\State\Domain\IdState;

class UpdateAdmin
{

    public function __construct(
        private AdminName $name,
        private AdminLastName $lastName,
        private AdminAbrv $abrv,
        private AdminNoDocument $noDocument,
        private AdminEmail $email,
        private AdminEmailAddress $emailAddress,
        private AdminAddress $address,
        private AdminPhone $phone,
        private AdminColor $color,
        private AdminIsAssignable $isAssignable,
        private AdminImgProfile $imgProfile,
        private AdminImgProfileThumb $imgProfileThumb,
        private AdminStatus $status,
        private IdTypeDocument $idTypeDocument,
        private IdAdminRole $idAdminRole,
        private IdCountry $idCountry,
        private IdState $idState,
        private IdCity $idCity,
        private IdAdmin $id
    ) {
    }

    public function name(): AdminName
    {
        return $this->name;
    }

    public function lastName(): AdminLastName
    {
        return $this->lastName;
    }

    public function abrv(): AdminAbrv
    {
        return $this->abrv;
    }

    public function noDocument(): AdminNoDocument
    {
        return $this->noDocument;
    }

    public function email(): AdminEmail
    {
        return $this->email;
    }

    public function emailAddress(): AdminEmailAddress
    {
        return $this->emailAddress;
    }

    public function address(): AdminAddress
    {
        return $this->address;
    }

    public function phone(): AdminPhone
    {
        return $this->phone;
    }

    public function color(): AdminColor
    {
        return $this->color;
    }

    public function isAssignable(): AdminIsAssignable
    {
        return $this->isAssignable;
    }

    public function imgProfile(): AdminImgProfile
    {
        return $this->imgProfile;
    }

    public function imgProfileThumb(): AdminImgProfileThumb
    {
        return $this->imgProfileThumb;
    }

    public function status(): AdminStatus
    {
        return $this->status;
    }

    public function idTypeDocument(): IdTypeDocument
    {
        return $this->idTypeDocument;
    }

    public function idAdminRole(): IdAdminRole
    {
        return $this->idAdminRole;
    }

    public function idCountry(): IdCountry
    {
        return $this->idCountry;
    }

    public function idState(): IdState
    {
        return $this->idState;
    }

    public function idCity(): IdCity
    {
        return $this->idCity;
    }

    public function id(): IdAdmin
    {
        return $this->id;
    }
}
