<?php

namespace App\Modules\Admin\Application\Update;

use App\Modules\Admin\Application\Update\AdminUpdaterResponse;
use App\Modules\Admin\Domain\AdminRepository;
use App\Modules\Admin\Domain\UpdateAdmin;

final class AdminUpdater
{
    public function __construct(private AdminRepository $repository)
    {
    }

    public function __invoke(UpdateAdmin $admin): AdminUpdaterResponse
    {
        return new AdminUpdaterResponse($this->repository->update($admin));
    }
}
