<?php

namespace App\Modules\Admin\Application\Index;

use App\Modules\Admin\Application\Index\AdminIndexerResponse;
use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Admin\Domain\AdminRepository;

final class AdminIndexer
{
    public function __construct(private AdminRepository $repository)
    {
    }

    public function __invoke(IdAdmin $idAdmin): AdminIndexerResponse
    {
        return new AdminIndexerResponse($this->repository->index($idAdmin));
    }
}
