<?php

namespace App\Modules\Admin\Application\Delete;

use App\Modules\Admin\Application\Delete\AdminDeleterResponse;
use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Admin\Domain\AdminRepository;

final class AdminDeleter
{
    public function __construct(private AdminRepository $repository)
    {
    }

    public function __invoke(IdAdmin $idAdmin): AdminDeleterResponse
    {
        return new AdminDeleterResponse($this->repository->delete($idAdmin));
    }
}
