<?php

namespace App\Http\Controllers\Passenger\ReviewSession;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Passenger\Application\ReviewFromGroup\ReviewFromGroupPassengerQuery;
use App\Modules\Passenger\Application\ReviewFromGroup\ReviewFromGroupPassengerResponses;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class ReviewSessionDetailController
{

    private $domain = 'ReviewSessionDetail';
    public function __construct(
        private CommandBus $commandBus,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($idGroupProvider)
    {
        $groupProvider = $this->getGroupProvider($idGroupProvider)['Response_Data'];
        $provider = $this->getProvider($groupProvider[0]->Id_Provider);
        $response = $this->getGroupProviderPassengers($groupProvider[0]->Id_Group);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [
                'Provider' => $provider[0],
                'Group' => $groupProvider[0],
                'Passenger' => $response->data()
            ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
        return ResponseBuilder::Response($response);
    }

    private function getGroupProvider($idGroupProvider)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_group_provider_index_by_review(?, @sts, @cod, @msg)',
            [$idGroupProvider]
        );
    }

    private function getProvider($idProvider)
    {
        return DB::select('CALL sp_provider_index(?)', [$idProvider]);
    }

    /** @return ReviewFromGroupPassengerResponses */
    private function getGroupProviderPassengers($idGroup)
    {
        return $this->queryBus->ask(new ReviewFromGroupPassengerQuery($idGroup));
    }
}
