<?php

namespace App\Http\Controllers\Passenger\GroupProviderMedia;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProviderMedia\Application\GroupProviderMediaResponses;
use App\Modules\GroupProviderMedia\Application\List\ListGroupProviderMediaQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class GroupProviderMediaListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "GroupProviderMedia";
    }

    public function __invoke($Id_GroupProvider, $Action)
    {
        $this->transaction->begin();
        /** @var GroupProviderMediaResponses $response */
        $response = $this->queryBus->ask(new ListGroupProviderMediaQuery($Id_GroupProvider, $Action));
        $data = array_map([GroupProviderMediaListController::class, 'appendPath'], $response->data());
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $data,
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }

    public static function appendPath($gpm)
    {
        if ($gpm->GroupProviderMedia_Path) {
            $gpm->GroupProviderMedia_Path = config('var.PATH_PUBLIC') . $gpm->GroupProviderMedia_Path;
        }
        if ($gpm->GroupProviderMedia_Path_Thumb) {
            $gpm->GroupProviderMedia_Path_Thumb = config('var.PATH_PUBLIC') . $gpm->GroupProviderMedia_Path_Thumb;
        }
        return $gpm;
    }
}
