<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;

class c_Tour_Upgrade extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Tour Upgrade";
		$this->history = new HistoryData(HistoryTables::tour_upgrade);
	}

	public function Insert(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(    'TourUpgrade_Select'	=> 'required|int',
								'TourUpgrade_Day'		=> 'required|int',
								'TourUpgrade_RequireDay'=> 'required|int',
								'TourUpgrade_Status'	=> 'required|int',
								'Id_Upgrade'	        => 'required|int',
								'Id_TourUpgradeType'    => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(    $Request->input("TourUpgrade_Select"),
								$Request->input("TourUpgrade_Day"),
								$Request->input("TourUpgrade_RequireDay"),
								$Request->input("TourUpgrade_Status"),
								$Request->input("Id_Upgrade"),
								$Request->input("Id_TourUpgradeType")
							);
			$oData = DB::select('call sp_tour_upgrade_insert(?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->insertBasic ($Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_TourUpgrade'		=> 'required|int',
								'TourUpgrade_Order'		=> 'required|int',
								'TourUpgrade_Select'	=> 'required|int',
								'TourUpgrade_Day'		=> 'required|int',
								'TourUpgrade_RequireDay'=> 'required|int',
								'TourUpgrade_Status'	=> 'required|int',
								'Id_Upgrade'	        => 'required|int',
								'Id_TourUpgradeType'    => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_TourUpgrade'));
			//endregion

			$oParam = array(    $Request->input("Id_TourUpgrade"),
								$Request->input("TourUpgrade_Order"),
								$Request->input("TourUpgrade_Select"),
								$Request->input("TourUpgrade_Day"),
								$Request->input("TourUpgrade_RequireDay"),
								$Request->input("TourUpgrade_Status"),
								$Request->input("Id_Upgrade"),
								$Request->input("Id_TourUpgradeType")
							);
			$oData = DB::select('call sp_tour_upgrade_update(?,?,?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_TourUpgrade"), $Request );
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY
			$this->history->obtainOld($Id);
			//endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_tour_upgrade_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_tour_upgrade_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_TourUpgradeType, $Id){
		$oResponse  = array();
		
		$oResponse = ParamsValidator::Validate_Id($Id_TourUpgradeType,$this->oDomain);
		
		if ($oResponse["Response_Code"] == 200) {
			$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

			if ($oResponse["Response_Code"] == 200) {
				$oParam = array( $Id, $Id_TourUpgradeType );
				$oData  = DB::select('call sp_tour_upgrade_list(?,?)',$oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
		}
		return ResponseBuilder::Response($oResponse);
	}

	
}