<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlRoom\Application\HtlRoomDeleter;
use App\Modules\HtlRoom\Application\HtlRoomFinder;
use App\Modules\HtlRoom\Application\HtlRoomIndexer;
use App\Modules\HtlRoom\Application\HtlRoomInserter;
use App\Modules\HtlRoom\Application\HtlRoomUpdater;
use App\Modules\HtlRoom\Domain\HRIdHtlCamp;
use App\Modules\HtlRoom\Domain\HtlRoom;
use App\Modules\HtlRoom\Domain\HtlRoomAvailability;
use App\Modules\HtlRoom\Domain\HtlRoomNumber;
use App\Modules\HtlRoom\Domain\HtlRoomStatus;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\HtlRoom\Domain\InsertHtlRoom;
use App\Modules\HtlRoom\Infraestructure\HtlRoomValidators;
use App\Modules\HtlRoom\Infraestructure\MysqlHtlRoomRepository;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Throwable;

class c_HtlRoom extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "HtlRoom";
        $this->history = new HistoryData(HistoryTables::htl_room);
    }

    public function Insert(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlRoomValidators::insert);

        $oResponse = (new HtlRoomInserter(new MysqlHtlRoomRepository, $this->queryBus))->__invoke(
            new InsertHtlRoom(
                new HtlRoomNumber($Request->input('HtlRoom_Number')),
                new HtlRoomAvailability(0),
                new HtlRoomStatus($Request->input('HtlRoom_Status')),
                new IdHtlTypeRoom($Request->input('Id_HtlTypeRoom')),
                new HRIdHtlCamp($Request->input('Id_HtlCamp'))
            )
        );
        $this->history->insert(
            (new HtlRoomIndexer(new MysqlHtlRoomRepository))->__invoke(new IdHtlRoom($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlRoomValidators::update);

        $this->history->obtainOld($Request->input('Id_HtlRoom'));

        $oResponse = (new HtlRoomUpdater(new MysqlHtlRoomRepository))->__invoke(
            new HtlRoom(
                new HtlRoomNumber($Request->input('HtlRoom_Number')),
                new HtlRoomStatus($Request->input('HtlRoom_Status')),
                new HRIdHtlCamp(0),
                new IdHtlRoom($Request->input('Id_HtlRoom'))
            )
        );

        $this->history->update(
            $Request->input('Id_HtlRoom'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $request, $Id)
    {
        try {
            return $this->DeleteFunction($request, $Id);
        } catch (Throwable $ex) {
            return (new LaravelExceptionHandler())->handle($ex);
        }
    }

    public function DeleteFunction(Request $request, $Id)
    {

        $this->history->obtainOld($Id);

        $oResponse = (new HtlRoomDeleter(new MysqlHtlRoomRepository))->__invoke(new IdHtlRoom($Id));

        $this->history->delete(
            $Id,
            $this->history->oldValue,
            $request
        );

        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id)
    {
        $oResponse = (new HtlRoomIndexer(new MysqlHtlRoomRepository))->__invoke(new IdHtlRoom($Id));
        return ResponseBuilder::Response($oResponse);
    }

    public function List($Id_HtlCamp, $Action, Request $Request)
    {
        $query = $Request->input("query") ? $Request->input("query") : '';
        $oResponse = (new HtlRoomFinder(new MysqlHtlRoomRepository))->__invoke(new IdHtlCamp($Id_HtlCamp), $Action, $query);
        return ResponseBuilder::Response($oResponse);
    }
}
