<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;

use App\Http\Helpers\ResponseBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class c_History extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "History";
    }

    public static function Insert(
        $Request,
        $Value_Old,
        $Value_New,
        $Operation,
        $Id_Record,
        $Id_HistoryTable
    ) {
        //
        //  SETEA VALORES PARA EL PROCEDIMIENTO ALMACENADO
        //
        $History_ValueOld   = $Value_Old;
        $History_ValueNew   = $Value_New;
        $History_Operation  = $Operation;
        $Token              = $Request->header("Token");


                
        $oParam = array(    $History_ValueOld,
                            $History_ValueNew,
                            $History_Operation,
                            $Id_Record,
                            $Id_HistoryTable,
                            $Token
                        );
        $oData = DB::select('call sp_history_insert(?,?,?,?,?,?)', $oParam);
        
        //  RESPONSE
        if ($oData[0]->Response_Success == 1) {
        } else {
        }
        
        $oResponse["Response_Status"]           = $oData[0]->Response_Status;
        $oResponse["Response_Code"]             = $oData[0]->Response_Code;
        $oResponse["Response_Domain"]           = "History";
        $oResponse["Response_Message"]          = $oData[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        
        return ResponseBuilder::Response($oResponse);
    }


    public static function Value_Old($Id_HistoryTable, ...$Params)
    {
        $oProcedure     = DB::select('call sp_history_table_index(?)', [$Id_HistoryTable]);
        $oData          = DB::select("call " . $oProcedure[0]->HistoryTable_Procedure, $Params);

        return $oData;
    }

        
    public function List(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_HistoryTable'   => 'required|int',
                                'Id_Record'         => 'required|int'
                            );
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Request->input("Id_HistoryTable"),
                $Request->input("Id_Record")
            ];

            $oData  = DB::select('call sp_history_list(?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
