<?php

namespace App\Http\Controllers\Owner\WebContact;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContact\Application\Update\UpdateWebContactQuery;
use App\Modules\WebContact\Application\Update\UpdateWebContactQueryResponse;
use App\Modules\WebContact\Infraestructure\WebContactValidators;

class WebContactUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContact";
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactValidators::UPDATE);

        /** @var UpdateWebContactQueryResponse $response */
        $response = $this->queryBus->ask(new UpdateWebContactQuery(
            $request->input('Id_WebContact'),
            $request->input('WebContact_Name'),
            $request->input('WebContact_LastName'),
            $request->input('WebContact_Email'),
            $request->input('WebContact_PhoneCode'),
            $request->input('WebContact_Phone'),
            $request->input('WebContact_Status'),
        ));

        $this->history->updateBasic($request->input("Id_WebContact"), $request);

        return ResponseBuilder::Response($response->response());
    }
}
