<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TypeDocument\Infraestructure\TypeDocumentInsertValidators;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class TypeDocument extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Type Document";
        $this->history = new HistoryData(HistoryTables::type_document);
    }

    public function insert(Request $Request)
    {

        (new LaravelValidator())->validate($Request->all(), $this->oDomain, TypeDocumentInsertValidators::BASIC);

        $oParam = [
            $Request->input("TypeDocument_Name"),
            Str::upper($Request->input("TypeDocument_Abrv")),
            $Request->input("TypeDocument_ForPassenger"),
            $Request->input("TypeDocument_Status")
        ];

        $oData = DB::select('call sp_type_document_insert(?,?,?,?)', $oParam);

        //  RESPONSE
        if ($oData[0]->Response_Success == 1) {
            //region HISTORY EXEC
            $this->history->insertBasic($Request);
            //endregion
        } else {
        }

        $oResponse = [];
        $oResponse["Response_Status"]           = $oData[0]->Response_Status;
        $oResponse["Response_Code"]             = $oData[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $oData[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;

        return ResponseBuilder::Response($oResponse);
    }

    public function update(Request $Request)
    {
        $oValParams = [
            'Id_TypeDocument'           => 'required|int',
            'TypeDocument_Name'         => 'required|string|max:250',
            'TypeDocument_Abrv'         => 'required|string|max:4',
            'TypeDocument_ForPassenger' => 'required|int',
            'TypeDocument_Order'        => 'required|int',
            'TypeDocument_Status'       => 'required|int'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            //region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_TypeDocument'));
            //endregion

            $oParam = [
                $Request->input("Id_TypeDocument"),
                trim($Request->input("TypeDocument_Name")),
                Str::upper($Request->input("TypeDocument_Abrv")),
                $Request->input("TypeDocument_ForPassenger"),
                $Request->input("TypeDocument_Order"),
                $Request->input("TypeDocument_Status")
            ];
            $oData = DB::select('call sp_type_document_update(?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->updateBasic($Request->input("Id_TypeDocument"), $Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_type_document_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                //region HISTORY EXEC
                $this->history->deleteBasic($Id, $Request);
                //endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_type_document_index(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function list(Request $Request, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_type_document_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return $this->index($Request, $Id);
        } else {
            return $this->list($Request, $Id);
        }
    }
}
