<?php

namespace App\Http\Controllers\Owner\TypeBookingAssign;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TypeBookingAssign\Application\Create\CreateTypeBookingAssignQuery;
use App\Modules\TypeBookingAssign\Application\Create\CreateTypeBookingAssignResponse;
use App\Modules\TypeBookingAssign\Infraestructure\TypeBookingAssignValidators;

class TypeBookingAssignInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "TypeBookingAssign";
        $this->history = new HistoryData(HistoryTables::TYPE_BOOKING_ASSIGN);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, TypeBookingAssignValidators::INSERT);

        /** @var CreateTypeBookingAssignResponse $response */
        $response = $this->queryBus->ask(new CreateTypeBookingAssignQuery(
            $request->input('TypeBookingAssign_Name'),
            $request->input('TypeBookingAssign_Abrv'),
            $request->input('TypeBookingAssign_Score'),
            $request->input('TypeBookingAssign_Status')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
