<?php

namespace App\Http\Controllers\Owner\TourHtlCamp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\TourHtlCamp\Application\TourHtlCampUpdater;
use App\Modules\TourHtlCamp\Domain\THCIdHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCampDay;
use App\Modules\TourHtlCamp\Domain\TourHtlCampStatus;
use App\Modules\TourHtlCamp\Domain\IdTourHtlCamp;
use App\Modules\TourHtlCamp\Infraestructure\TourHtlCampValidators;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TourHtlCamp\Domain\THCIdTour;

class TourHtlCampUpdateController extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "TourHtlCamp";
        $this->history = new HistoryData(HistoryTables::TOUR_HTL_CAMP);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, TourHtlCampValidators::update);

        $this->history->obtainOld($Request->input('Id_TourHtlCamp'));

        $oResponse = (new TourHtlCampUpdater(new MysqlTourHtlCampRepository))->__invoke(
            new TourHtlCamp(
                new TourHtlCampDay($Request->input('TourHtlCamp_Day')),
                new TourHtlCampStatus($Request->input('TourHtlCamp_Status')),
                new THCIdTour(0),
                new THCIdHtlCamp(0),
                new IdTourHtlCamp($Request->input('Id_TourHtlCamp'))
            )
        );

        $this->history->update(
            $Request->input('Id_TourHtlCamp'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }
}
