<?php

namespace App\Http\Controllers\Owner\TourHtlCamp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\TourHtlCamp\Application\TourHtlCampDeleter;
use App\Modules\TourHtlCamp\Domain\IdTourHtlCamp;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use Throwable;

class TourHtlCampDeleteController extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "TourHtlCamp";
        $this->history = new HistoryData(HistoryTables::TOUR_HTL_CAMP);
    }

    public function __invoke(Request $request, $Id)
    {
        try {
            return $this->DeleteFunction($request, $Id);
        } catch (Throwable $ex) {
            return (new LaravelExceptionHandler())->handle($ex);
        }
    }

    public function DeleteFunction(Request $request, $Id)
    {

        $this->history->obtainOld($Id);

        $oResponse = (new TourHtlCampDeleter(new MysqlTourHtlCampRepository))->__invoke(new IdTourHtlCamp($Id));

        $this->history->delete(
            $Id,
            $this->history->oldValue,
            $request
        );

        return ResponseBuilder::Response($oResponse);
    }
}
