<?php

namespace App\Http\Controllers\Owner\StatusGroupProvider;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\StatusGroupProvider\Application\Create\CreateStatusGroupProviderQuery;
use App\Modules\StatusGroupProvider\Application\Create\CreateStatusGroupProviderResponse;
use App\Modules\StatusGroupProvider\Infraestructure\StatusGroupProviderValidators;

class StatusGroupProviderInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "StatusGroupProvider";
        $this->history = new HistoryData(HistoryTables::STATUS_GROUP_PROVIDER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, StatusGroupProviderValidators::INSERT);

        /** @var CreateStatusGroupProviderResponse $response */
        $response = $this->queryBus->ask(new CreateStatusGroupProviderQuery(
            $request->input('StatusGroupProvider_Name'),
            $request->input('StatusGroupProvider_Abrv'),
            $request->input('StatusGroupProvider_Color'),
            $request->input('StatusGroupProvider_Status')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
