<?php
namespace App\Http\Controllers\Owner\ProviderTypeProvider;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ProviderTypeProvider\Application\Index\ProviderTypeProviderIndexerQuery;
use App\Modules\ProviderTypeProvider\Application\Index\ProviderTypeProviderIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderTypeProviderIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var ProviderTypeProviderIndexerResponse $response */
        $response = $this->queryBus->ask(new ProviderTypeProviderIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
