<?php
namespace App\Http\Controllers\Owner\ProviderSanction;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ProviderSanction\Application\Delete\ProviderSanctionDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderSanctionDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::PROVIDER_SANCTION);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var ProviderSanctionDeleterResponse $response */
        $response = $this->queryBus->ask(new ProviderSanctionDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
