<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Modules\BookingTourPassenger\Application\Index\IndexBookingTourPassengerQuery;
use App\Modules\BookingTourPassenger\Application\Index\IndexBookingTourPassengerResponse;
use App\Modules\BookingTourPassenger\Application\ListByPassenger\BookingTourPassengerListByPassengerQuery;
use App\Modules\BookingTourPassenger\Application\ListByPassenger\BookingTourPassengerListByPassengerResponse;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassenger;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingLock;
use App\Modules\HtlCampBookingPassenger\Application\ListByPassenger\ListByPassengerHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Application\ListByPassenger\ListByPassengerHtlCampBookingPassengerResponses;
use App\Modules\HtlCampBookingPassenger\Application\Update\UpdateHtlCampBookingPassengerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class PassengerUpdater
{

    public function __construct(
        private QueryBus $queryBus
    ) {}


    public function updateLockHtlCampBookingPassenger($idPassenger, $booking = null)
    {
        /** @var BookingTourPassengerListByPassengerResponse $bookingTourPassengers */
        $bookingTourPassengers = $this->queryBus->ask(new BookingTourPassengerListByPassengerQuery($idPassenger));

        foreach ($bookingTourPassengers->response()['Response_Data'] as $btp) {
            $bookingIndex = $this->getBookingIndex($btp->Id_BookingTour, $booking);
            /** @var ListByPassengerHtlCampBookingPassengerResponses $campPassengers */
            $campPassengers = $this->queryBus->ask(new ListByPassengerHtlCampBookingPassengerQuery(
                $btp->Id_BookingTourPassenger,
                'all_deleted'
            ));
            $status = BookingTourPassenger::genHtlCampBookingPassengerStatus($bookingIndex, $btp);

            $this->updateStatus($this->filterLocked($campPassengers->data()), $status);
        }
    }


    public function updateLockedHtlCampBookingPassenger($idBookingTourPassenger, $booking = null)
    {
        /** @var IndexBookingTourPassengerResponse $bookingTourPassenger */
        $bookingTourPassenger = $this->queryBus->ask(new IndexBookingTourPassengerQuery($idBookingTourPassenger));

        foreach ($bookingTourPassenger->response()['Response_Data'] as $btp) {
            $bookingIndex = $this->getBookingIndex($btp->Id_BookingTour, $booking);
            /** @var ListByPassengerHtlCampBookingPassengerResponses $campPassengers */
            $campPassengers = $this->queryBus->ask(new ListByPassengerHtlCampBookingPassengerQuery(
                $btp->Id_BookingTourPassenger,
                'all'
            ));
            $status = BookingTourPassenger::genHtlCampBookingPassengerStatus($bookingIndex, $btp);
            $this->updateStatus($this->filterLocked($campPassengers->data()), $status);
        }
    }

    private function getBookingIndex($Id_BookingTour, $booking = null)
    {
        if ($booking !== null) {
            return $booking;
        } else {
            $bookignTourIndex = DB::select('call sp_booking_tour_index(?)', [$Id_BookingTour])[0];
            return DB::select('CALL sp_booking_index(?)', [$bookignTourIndex->Id_Booking])[0];
        }
    }

    public function filterLocked($array)
    {
        return array_filter($array, fn($pass) => $pass->HtlCampBooking_Lock === HtlCampBookingLock::VALUE_TRUE);
    }

    public function updateStatus($campPassengers, $status)
    {
        return array_map(fn($campPassenger) => $this->queryBus->ask(new UpdateHtlCampBookingPassengerQuery(
            $campPassenger->Id_HtlCampBookingPassenger,
            $campPassenger->HtlCampBookingPassenger_Weight,
            $status
        )), $campPassengers);
    }

    // public function 
}
