<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Passenger\Application\Remove\RemovePassengerQuery;
use App\Modules\Passenger\Application\Remove\RemovePassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PassengerRemoveController
{
    private HistoryData $history;
    
    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::passenger);
    }

    public function findBooking($Id_Passenger)
    {
        $passenger = $this->findIndex($Id_Passenger);
        return $passenger ? $passenger->Id_Booking : $passenger;
    }

    public function findIndex($Id_Passenger)
    {
        $found = DB::select('CALL sp_passenger_index(?,?,?,?,?)', [$Id_Passenger, '', '', '', '']);

        if (count($found)) {
            return $found[0];
        } else {
            return null;
        }
    }

    public function __invoke($IdPassenger, Request $request)
    {
        $this->history->obtainOld($IdPassenger);

        /** @var RemovePassengerResponse $response */
        $response = $this->queryBus->ask(new RemovePassengerQuery($IdPassenger));
        $this->history->delete(
            $this->findBooking($IdPassenger),
            $this->history->oldValue,
            $request
        );
        return ResponseBuilder::Response($response->response());
    }
}
