<?php
namespace App\Http\Controllers\Owner\LeadBookingServicePassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingServicePassenger\Application\Delete\LeadBookingServicePassengerDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServicePassengerDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingServicePassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_SERVICE_PASSENGER);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadBookingServicePassengerDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServicePassengerDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
