<?php

namespace App\Http\Controllers\Owner\Lead;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Lead\Application\Create\LeadInserterQuery;
use App\Modules\Lead\Application\Create\LeadInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Lead\Infraestructure\LeadValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Lead";
        $this->history = new HistoryData(HistoryTables::LEAD);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadValidators::INSERT);
        /** @var LeadInserterResponse $response */
        $response = $this->queryBus->ask(new LeadInserterQuery(
            $request->input('Lead_Name'),
            $request->input('Lead_LastName'),
            $request->input('Lead_Gender'),
            $request->input('Lead_Email'),
            $request->input('Lead_PhoneCode'),
            $request->input('Lead_Phone'),
            $request->input('Lead_NoDocument'),
            $request->input('Lead_Address'),
            $request->input('Lead_ContactName'),
            $request->input('Lead_ContactPhone'),
            $request->input('Lead_Type'),
            $request->input('Lead_Status'),
            $request->input('Id_TypeDocument'),
            $request->input('Id_UserCountry'),
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
