<?php

namespace App\Http\Controllers\Owner\HtlTypeRoomBed;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlTypeRoomBed\Application\Update\UpdateHtlTypeRoomBedQuery;
use App\Modules\HtlTypeRoomBed\Infrastructure\HtlTypeRoomBedValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomBedUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoomBed";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM_BED);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlTypeRoomBedValidators::UPDATE);
        $this->transaction->begin();
        $this->history->obtainOld($request->input('Id_HtlTypeRoomBed'));
        $this->queryBus->ask(new UpdateHtlTypeRoomBedQuery(
            $request->input('Id_HtlTypeRoomBed'),
            $request->input('HtlTypeRoomBed_Status'),
        ));
        $this->history->updateBasic($request->input('Id_HtlTypeRoomBed'), $request);
        $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación Cama modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
