<?php

namespace App\Http\Controllers\Owner\HtlCampBooking;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlCampBooking\Application\Update\UpdateHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Infrastructure\HtlCampBookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBooking";
        $this->history = new HistoryData(HistoryTables::HTL_CAMP_BOOKING);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlCampBookingValidators::UPDATE);
        $this->history->obtainOld($request->input('Id_HtlCampBooking'));
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateHtlCampBookingQuery(
            $request->input('Id_HtlCampBooking'),
            $request->input('HtlCampBooking_DateStart'),
            $request->input('HtlCampBooking_Remark'),
            $request->input('HtlCampBooking_Status'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($request->input('Id_HtlCampBooking'), $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Reserva de campamento modificada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
