<?php
namespace App\Http\Controllers\Owner\HtlCampBooking;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlCampBooking\Application\HtlCampBookingResponse;
use App\Modules\HtlCampBooking\Application\Index\IndexHtlCampBookingQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBooking";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var HtlCampBookingResponse $response */
        $response = $this->queryBus->ask(new IndexHtlCampBookingQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ $response ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Index',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
