<?php

namespace App\Http\Controllers\Owner\GroupPassengerMedia;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassengerMedia\Application\GroupPassengerMediaResponses;
use App\Modules\GroupPassengerMedia\Application\List\ListGroupPassengerMediaQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Providers\StorageProvider;

class GroupPassengerMediaListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction,
        private StorageProvider $storage
    ) {
        $this->domain = "GroupPassengerMedia";
    }

    public function __invoke($Id_GroupPassenger, $Action)
    {
        $this->transaction->begin();
        /** @var GroupPassengerMediaResponses $response */
        $response = $this->queryBus->ask(new ListGroupPassengerMediaQuery($Id_GroupPassenger, $Action));
        $data = array_map([$this, 'appendPath'], $response->data());
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $data,
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }

    public function appendPath($gpm)
    {
        $this->storage->appendPublicToObject($gpm, 'GroupPassengerMedia_Path');
        $this->storage->appendPublicToObject($gpm, 'GroupPassengerMedia_Path_Thumb');
        $this->storage->appendPublicToObject($gpm, 'GroupPassengerMedia_Path_LargeThumb');
        return $gpm;
    }
}
