<?php

namespace App\Http\Controllers\Owner\GroupPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\GroupPassenger\Application\UpdateMediaScore\UpdateMediaScoreGroupPassengerQuery;
use App\Modules\GroupPassenger\Infraestructure\GroupPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class GroupPassengerUpdateScoreController extends Controller
{
    private string $domain = 'GroupPassenger';
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::GROUP_PROVIDER);
    }

    public function __invoke(Request $request, $Id_GroupPassenger)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, GroupPassengerValidators::UPDATE_SCORE);

        $this->history->obtainOld($Id_GroupPassenger);
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateMediaScoreGroupPassengerQuery(
            $Id_GroupPassenger,
            $request->input('GroupPassenger_MediaScore'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($Id_GroupPassenger, $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Proveedor de grupo modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
