<?php

namespace App\Http\Controllers\Owner\GroupPassenger;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Application\GroupPassengerListWithReview;
use App\Modules\GroupPassenger\Infraestructure\MysqlGroupPassengerRepository;
use Illuminate\Http\Request;

final class GroupPassengerListWithReviewController extends Controller
{
    private $oDomain;
    public function __construct()
    {
        $this->oDomain = 'GroupPassenger';
    }

    public function __invoke($Id_Group, Request $Request)
    {
        $path           = config("var.PATH_PUBLIC");
        $pathCountry    = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB");

        $response = (new GroupPassengerListWithReview(new MysqlGroupPassengerRepository))
            ->__invoke(
                new IdGroup($Id_Group),
                $path,
                $pathCountry
            );
        return ResponseBuilder::Response($response);
    }
}
