<?php

namespace App\Http\Controllers\Owner\GroupPassenger;

use App\Http\Controllers\Controller;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\GroupPassenger\Application\DownloadMedia\DownloadMediaGroupPassengerQuery;
use App\Modules\GroupPassenger\Application\DownloadMedia\DownloadMediaGroupPassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Providers\StorageProvider;
use App\Providers\ZipGenerator\ZipGenerator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

final class GroupPassengerDownloadMediaController extends Controller
{
    private string $domain = 'GroupPassenger';
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction,
        private ZipGenerator $zipGenerator,
        private StorageProvider $storageProvider
    ) {
        $this->history = new HistoryData(HistoryTables::GROUP_PROVIDER);
    }

    public function __invoke(Request $request, $Id_GroupPassenger)
    {
        $this->history->obtainOld($Id_GroupPassenger);

        $this->transaction->begin();
        /** @var DownloadMediaGroupPassengerResponse $response */
        $response = $this->queryBus->ask(new DownloadMediaGroupPassengerQuery(
            $Id_GroupPassenger,
        ));
        $this->transaction->commit();
        $this->history->updateBasic($Id_GroupPassenger, $request);
        $groupPassengerMediaList = array_map([self::class, 'appendPrivate'], $response->data()[0]['GroupPassengerMedia']);
        $files = array_map(fn ($data) => $data->GroupPassengerMedia_Path, $groupPassengerMediaList);
        $index = $this->getGroupPassenger($Id_GroupPassenger);

        $zipFileName = $this->zipGenerator->generateFromFiles($files, $this->filename($index[0]));

        return response()->download($this->storageProvider->privatePath($zipFileName))->deleteFileAfterSend(true);
    }

    private function filename($groupPassenger)
    {
        return $this->formatName(
            date('Y-m-d', strtotime($groupPassenger->Group_DateStart))
                . ' '
                . $groupPassenger->Tour_Code
                . ' '
                . $groupPassenger->Passenger_Name
        );
    }

    private function formatName(string $name)
    {
        return preg_replace('/([^ A-Za-z0-9-])/', '', $name);
    }

    private function getGroupPassenger($idGroupPassenger)
    {
        return DB::select(
            'CALL sp_group_passenger_index(?,?)',
            [$idGroupPassenger, '']
        );
    }

    public static function appendPrivate($gpm)
    {
        if ($gpm->GroupPassengerMedia_Path) {
            $gpm->GroupPassengerMedia_Path = config('var.PATH_PRIVATE') . $gpm->GroupPassengerMedia_Path;
        }
        if ($gpm->GroupPassengerMedia_Path_Thumb) {
            $gpm->GroupPassengerMedia_Path_Thumb = config('var.PATH_PRIVATE') . $gpm->GroupPassengerMedia_Path_Thumb;
        }
        $gpm->GroupPassengerMedia_Download = 'groupPassengerMedia/' . $gpm->Id_GroupPassengerMedia . '/download';
        return $gpm;
    }

    public static function appendPath($gpm)
    {
        if ($gpm->GroupPassengerMedia_Path) {
            $gpm->GroupPassengerMedia_Path = config('var.PATH_PUBLIC') . $gpm->GroupPassengerMedia_Path;
        }
        if ($gpm->GroupPassengerMedia_Path_Thumb) {
            $gpm->GroupPassengerMedia_Path_Thumb = config('var.PATH_PUBLIC') . $gpm->GroupPassengerMedia_Path_Thumb;
        }
        $gpm->GroupPassengerMedia_Download = 'groupPassengerMedia/' . $gpm->Id_GroupPassengerMedia . '/download';
        return $gpm;
    }
}
