<?php

namespace App\Http\Controllers\Owner\FactTypeReceipt;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactTypeReceipt\Application\Update\FactTypeReceiptUpdaterQuery;
use App\Modules\FactTypeReceipt\Application\Update\FactTypeReceiptUpdaterResponse;
use App\Modules\FactTypeReceipt\Infraestructure\FactTypeReceiptValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeReceiptUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactTypeReceipt";
        $this->history = new HistoryData(HistoryTables::FACT_TYPE_RECEIPT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactTypeReceiptValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactTypeReceipt"));

        /** @var FactTypeReceiptUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactTypeReceiptUpdaterQuery(
            $request->input('Id_FactTypeReceipt'),
            $request->input('FactTypeReceipt_Name'),
            $request->input('FactTypeReceipt_Abrv'),
            $request->input('FactTypeReceipt_Status'),
        ));

        $this->history->updateBasic($request->input("Id_FactTypeReceipt"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
