<?php

namespace App\Http\Controllers\Owner\FactTypeDocument;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactTypeDocument\Application\FactTypeDocumentResponses;
use App\Modules\FactTypeDocument\Application\List\FactTypeDocumentListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeDocumentListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var FactTypeDocumentResponses $response */
        $response = $this->queryBus->ask(new FactTypeDocumentListerQuery($Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
