<?php

namespace App\Http\Controllers\Owner\FactPaymentMethod;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactPaymentMethod\Application\Delete\DeleteFactPaymentMethodQuery;
use App\Modules\FactPaymentMethod\Application\Delete\DeleteFactPaymentMethodResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactPaymentMethodDeleteController extends Controller
{
    private $domain = "FactPaymentMethod";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::FACT_PAYMENT_METHOD);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        $this->transaction->begin();
        /** @var DeleteFactPaymentMethodResponse $response */
        $response = $this->queryBus->ask(new DeleteFactPaymentMethodQuery($Id));

        $this->transaction->commit();
        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Metodo de Pago de Facturación eliminado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
