<?php

namespace App\Http\Controllers\Owner\ExternalReview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ExternalReview\Application\ExternalReviewFinder;
use App\Modules\ExternalReview\Infraestructure\ExternalReviewValidators;
use App\Modules\ExternalReview\Infraestructure\MysqlExternalReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class ExternalReviewListController extends Controller
{
    private $domain;
    public function __construct()
    {
        $this->domain = "ExternalReview";
    }

    public function __invoke($Action, Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ExternalReviewValidators::FIND);
        $oResponse = (new ExternalReviewFinder(new MysqlExternalReviewRepository))
            ->__invoke(
                $Action,
                new DateStart($request->input('DateStart')),
                new DateEnd($request->input('DateEnd')),
            );
        return ResponseBuilder::Response($oResponse);
    }
}
