<?php
namespace App\Http\Controllers\Owner\ExternalReview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalReview\Application\ExternalReviewDeleter;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\ExternalReview\Infraestructure\MysqlExternalReviewRepository;

class ExternalReviewDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->history = new HistoryData(HistoryTables::EXTERNAL_REVIEW);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        $response = (new ExternalReviewDeleter(new MysqlExternalReviewRepository()))
            ->__invoke(new IdExternalReview($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response);
    }
}
