<?php

namespace App\Http\Controllers\Owner\CashMovementFactReceipt;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\CashMovementFactReceipt\Application\Update\CashMovementFactReceiptUpdaterQuery;
use App\Modules\CashMovementFactReceipt\Application\Update\CashMovementFactReceiptUpdaterResponse;
use App\Modules\CashMovementFactReceipt\Infraestructure\CashMovementFactReceiptValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class CashMovementFactReceiptUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "CashMovementFactReceipt";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, CashMovementFactReceiptValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_CashMovementFactReceipt"));

        /** @var CashMovementFactReceiptUpdaterResponse $response */
        $response = $this->queryBus->ask(new CashMovementFactReceiptUpdaterQuery(
            $request->input('Id_CashMovementFactReceipt'),
            $request->input('CashMovementFactReceipt_Status'),
            $request->input('Id_CashMovement'),
            $request->input('Id_FactReceipt'),
        ));

        $this->history->updateBasic($request->input("Id_CashMovementFactReceipt"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
