<?php

namespace App\Http\Controllers\Owner\BookingUpgradePassenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingUpgradePassenger\Application\BookingUpgradePassengerResponses;
use App\Modules\BookingUpgradePassenger\Application\ListById\ListByIdBookingUpgradePassengerQuery;
use App\Modules\BookingUpgradePassenger\Infrastructure\BookingUpgradePassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingUpgradePassengerByIdsController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::BOOKING_EXTRA_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingUpgradePassengerValidators::LIST_BY_IDS);
        /** @var BookingUpgradePassengerResponses $response */
        $response = $this->queryBus->ask(new ListByIdBookingUpgradePassengerQuery($request->input('Ids')));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
