<?php

namespace App\Http\Controllers\Owner\BookingTourPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingTourPassenger\Application\BookingTourPassengerNotificationCreator;
use App\Modules\BookingTourPassenger\Application\Index\IndexBookingTourPassengerQuery;
use App\Modules\BookingTourPassenger\Application\Index\IndexBookingTourPassengerResponse;
use App\Modules\BookingTourPassenger\Application\UpdatePartial\UpdatePartialBookingTourPassengerQuery;
use App\Modules\BookingTourPassenger\Application\UpdatePartial\UpdatePartialBookingTourPassengerResponse;
use App\Modules\BookingTourPassenger\Infraestructure\BookingTourPassengerValidators;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

final class BookingTourPassengerUpdatePartialController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private CommandBus $commandBus,
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingTourPassenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_TOUR_PASSENGER);
    }

    private function findBooking($Id)
    {
        $found = DB::select(
            'Call sp_booking_tour_passenger_index(?, ?)',
            [$Id, config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')]
        );

        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $request, $Id)
    {
        (new LaravelValidator)->validate($request->all(), $this->domain, BookingTourPassengerValidators::UPDATE_PARTIAL);

        $this->history->obtainOld($Id);

        $hasBeenPrinted = $request->input('BookingTourPassenger_HasBeenPrinted');

        /** @var IndexBookingTourPassengerResponse */
        $indexResponse = $this->queryBus->ask(new IndexBookingTourPassengerQuery($Id));
        $model = $indexResponse->response()[0];

        /** @var UpdatePartialBookingTourPassengerResponse $update */
        $update = $this->queryBus->ask(new UpdatePartialBookingTourPassengerQuery(
            $Id,
            $request->input('BookingTourPassenger_HasBeenPrinted')
        ));

        (new BookingTourPassengerNotificationCreator($this->commandBus))
            ->__invoke($Id, $request->header('Token'));

        $this->history->obtainNew($Id);

        $this->history->update(
            $this->findBooking($Id),
            $this->history->oldValue,
            $this->history->newValueCache,
            $request
        );
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Pasajero de tour modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
