<?php

namespace App\Http\Controllers\Owner\BookingConfirmation;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Owner\Booking;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BookingConfirmationReport extends Controller
{
    private $oDomain;

    public function __construct(
        private LaravelValidator $validator
    ) {
        $this->oDomain = "Booking";
    }
    public function __invoke(Request $request, $Id_Booking)
    {
        $invoiceListJSON = $this->convertToJsonInvoices(Booking::getInvoiceList($Id_Booking));
        $oParam = array($Id_Booking);
        $oData = Booking::mapBookingList(
            DB::select('call sp_booking_index(?)', $oParam),
            $invoiceListJSON
        );

        return ResponseBuilder::Response([
            "Response_Status" => 200,
            "Response_Code" => 200,
            "Response_Domain" => $this->oDomain,
            "Response_Message" => $this->oDomain . " list ",
            "Response_Data" => $oData,
            "Response_Error_Message" => "",
            "Response_Error_Reason" => "",
        ]);
    }

    private function convertToJsonInvoices(array $invoiceList)
    {
        return json_encode(array_map(
            fn ($invoice) => (object)['Id' => $invoice->Id_Invoice],
            $invoiceList
        ));
    }
}
