<?php

namespace App\Http\Controllers\Owner\Booking;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Booking\Application\Search\BookingSearcherQuery;
use App\Modules\Booking\Application\Search\BookingSearcherResponse;
use App\Modules\Booking\Infraestructure\BookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingFindByCodeController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingValidators::SEARCH_BOOKING);
        /** @var BookingSearcherResponse $response */
        $response = $this->queryBus->ask(new BookingSearcherQuery($request->input('Booking_Code')));

        return ResponseBuilder::Response($response->response());
    }
}
