<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;

class c_User_Session extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "User Session";
	}

	public function Insert(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'User_Email'    	=> 'required|string|max:250',
			'User_Password'    	=> 'required|string|max:250'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(
				$Request->input("User_Email"),
				$Request->input("User_Password")
			);
			$oData = DB::select('call sp_client_user_session_insert(?,SHA1(?))', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$Response_Data	= array(
					"Token" 	=> $oData[0]->Response_Token,
					"Id_User" 	=> $oData[0]->Response_Id
				);
			} else {
				$Response_Data 	= null;
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= $Response_Data;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public static function Update(Request $Request)
	{
		if ($Request->header("Token") != "") {
			$oParam 	= array($Request->header("Token"));
			$oData 		= DB::select('call sp_client_user_session_update(?)', $oParam);

			return $oData;
		}
	}
	public function Delete(Request $Request)
	{
		$oResponse  = array();

		//  INGRESANDO DATOS
		if ($Request->header("Token") != "") {
			$oParam 	= array($Request->header("Token"));
			$oData 		= DB::select('call sp_client_user_session_delete(?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= NULL;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
}
