<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;

class c_Room extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Room";
	}

	public function Insert(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'Room_Observation'		=> 'required|string',
			'Id_Booking'			=> 'required|int',
			'Id_TypeRoom'			=> 'required|int'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(
				$Request->input("Room_Observation"),
				$Request->input("Id_Booking"),
				$Request->input("Id_TypeRoom")
			);
			$oData = DB::select('call sp_room_insert(?,?,?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Update(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'Id_Room'				=> 'required|int',
			'Room_Observation'		=> 'required|string',
			'Id_Booking'			=> 'required|int',
			'Id_TypeRoom'			=> 'required|int'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(
				$Request->input("Id_Room"),
				$Request->input("Room_Observation"),
				$Request->input("Id_Booking"),
				$Request->input("Id_TypeRoom")
			);
			$oData = DB::select('call sp_room_update(?,?,?,?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Delete(Request $Request, $Id)
	{
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array($Id);
			$oData 	= DB::select('call sp_room_delete(?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id)
	{
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array($Id);
			$oData 	= DB::select('call sp_room_index(?)', $oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_Booking)
	{
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id_Booking, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array($Id);
			$oData  = DB::select('call sp_room_list(?)', $oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " list " . $Id;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
}
