<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class BookingMother
{

    public static function build1($id = 1)
    {
        return [
            'Id_Booking'                    => $id,
            'Booking_Date'                  => date('Y-m-d H:i:s'),
            'Booking_DateStart'             => date('Y-m-d'),
            'Booking_DateBriefing'          => date('Y-m-d H:i:s', time() + 10 * 60 * 60),
            'Booking_PlaceBriefing'         => 'Place Briefing',
            'Booking_Code'                  => 'Code',
            'Booking_HistoryChanges'        => '',
            'Booking_Hotel'                 => '',
            'Booking_Observation'           => '',
            'Booking_Receipt'               => 1,
            'Booking_Type'                  => 2,
            'Booking_LastMinute'            => 2,
            'Booking_Status'                => 1,
            'Booking_ManuallyConfirmed'     => 1,
            'Booking_InPerson'              => 2,
            'Booking_Token'                 => '',
            'Id_Admin'                      => 0,
            'Id_GuideLanguage'              => 1,
            'Id_Language'                   => 1,
            'Id_User'                       => 1,
        ];
    }

    public static function push1($id = 1, $token = '')
    {
        return self::push(self::build1($id), $token);
    }

    private static function push($object, $token = '')
    {
        DB::select("CALL `sp_booking_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Booking_DateStart'],
            $object['Booking_Receipt'],
            $object['Booking_Type'],
            $object['Booking_Observation'],
            '',
            $object['Id_Language'],
            $object['Id_GuideLanguage'],
            $object['Id_User'],
            0,
            $object['Booking_InPerson'],
            1,
            1,
            $token
        ]);
        return $object;
    }
}
