<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TypeTourMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_TypeTour' => $id,
            'TypeTour_Name' => Str::title($faker->text(rand(5, 250))),
            'TypeTour_Abrv' => Str::upper(Util::generateString(4)),
            'TypeTour_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_type_tour_insert` (?,?,?)", [
            $object['TypeTour_Name'],
            $object['TypeTour_Abrv'],
            $object['TypeTour_Status']
        ]);
        $object['Id_TypeTour'] = $response[0]->Response_Id;
        return $object;
    }

}