<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadBookingMother
{
    
    public static function build1($idAdmin, $idGuideLanguage = null, $idLanguage = null, $idLead = null, $id = 1)
    {
        $idGuideLanguage = $idGuideLanguage ?? LanguageMother::pushBasic()['Id_Language'];
        $idLanguage = $idLanguage ?? LanguageMother::pushBasic()['Id_Language'];
        $idLead = $idLead ?? LeadMother::push1()['Id_Lead'];
        $faker = Factory::create();
        return [
            'Id_LeadBooking' => $id,
            'LeadBooking_Date' => date('Y-m-d H:i:s'),
            'LeadBooking_Observation' => $faker->text(rand(5, 100)),
            'LeadBooking_Contact' => $faker->randomElement([1, 2, 3]),
            'LeadBooking_CancellationReason' => $faker->randomElement([1, 2, 3]),
            'LeadBooking_CancellationRemark' => $faker->text(rand(5, 500)),
            'LeadBooking_Status' => $faker->randomElement([1, 2]),
            'Id_Admin' => $idAdmin,
            'Id_GuideLanguage' => $idGuideLanguage,
            'Id_Language' => $idLanguage,
            'Id_Lead' => $idLead,
        ];
    }

    public static function push1($idAdmin, $idGuideLanguage = null, $idLanguage = null, $idLead = null, $id = 1)
    {
        return self::push(self::build1($idAdmin, $idGuideLanguage, $idLanguage, $idLead, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_lead_booking_insert`(?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['LeadBooking_Observation'],
            $object['LeadBooking_Contact'],
            $object['LeadBooking_Status'],
            $object['Id_Admin'],
            $object['Id_GuideLanguage'],
            $object['Id_Language'],
            $object['Id_Lead'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_LeadBooking'] = $response[0]->{'@id'};
        } else {
            dd($response);
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::LEAD_BOOKING, ...LeadMother::tablesToClear(), TC::ADMIN, TC::LANGUAGE];
    }
}
