<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ExternalReviewProviderMother
{
    
    public static function build1($idGroupProvider, $idExternalReview, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_ExternalReviewProvider' => $id,
            'ExternalReviewProvider_Type' => $faker->randomElement([1, 2, 3]),
            'ExternalReviewProvider_Status' => $faker->randomElement([1, 2]),
            'Id_ExternalReview' => $idExternalReview,
            'Id_GroupProvider' => $idGroupProvider
        ];
    }

    public static function push1($idGroupProvider, $idExternalReview, $id = 1)
    {
        return self::push(self::build1($idGroupProvider, $idExternalReview, $id));
    }

    private static function push($object)
    {
        $response = DB::select(
            "CALL `sp_external_review_provider_insert`(?,?,?,?,@sts,@cod,@msg,@id)",
            [
                $object['ExternalReviewProvider_Type'],
                $object['ExternalReviewProvider_Status'],
                $object['Id_ExternalReview'],
                $object['Id_GroupProvider']
            ]
        );
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ExternalReviewProvider'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::EXTERNAL_REVIEW_PROVIDER,
            ...ExternalReviewMother::tablesToClear(),
            ...GroupProviderMother::tablesToClear(),
        ];
    }
}
